const mongoose = require("mongoose");
const validator = require("validator");

const formtSchema = new mongoose.Schema(
  {
    title: {
      type: String,
      required: [true, "Please provide your title"],
    },
    name: { type: String, required: [true, "Please provide your name"] },
    email: {
      type: String,
      required: [true, "Please provide your email"],
      lowercase: true,
      validate: [validator.isEmail, "Please provide a valid email"],
    },
    site: {
      type: String,
      required: [true, "Please provide your site"],
      lowercase: true,
      vaidate:[validator.isURL,'Please provide a valid URL']
    },
    description: {
      type: String,
      required: [true, "Please provide your description"],
    },
    phone: {
      type: String,
      required: [true, "Please provide your phone number"],
    },
    status:{
      type:Boolean,
      default:false
    },
    createdAt: {
      type: Date,
      default: Date.now(),
    },
  },
  {
    toJSON: { virtuals: true },
    toObject: { virtuals: true },
  }
);

formtSchema.pre("save", function (next) {
  this.createdAt = Date.now();
  next();
});
const Form = mongoose.model("Form", formtSchema);

module.exports = Form;
