  document.getElementById('contact-form').addEventListener('submit', async function (e) {
    e.preventDefault();

    const formData = {
      name: document.getElementById('name').value.trim(),
      phone: document.getElementById('phone').value.trim(),
      email: document.getElementById('email').value.trim(),
      location: document.getElementById('location').value.trim(),
      message: document.getElementById('message').value.trim(),
      country: "IR"
    };

    try {
      const response = await fetch('http://127.0.0.1:5000/api/v1/form', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(formData)
      });

      if (response.ok) {
        alert('Message sent successfully!');
        document.getElementById('contact-form').reset();
      } else {
        const err = await response.json();
        alert('Error: ' + (err.message || 'Something went wrong.'));
      }
    } catch (err) {
      console.error(err);
      alert('Network error. Check console for details.');
    }
  });