const dotenv = require("dotenv");
const mongoose = require("mongoose");
var fs = require('fs');


//-------------------------------------------------------------------

process.on("uncaughtException", (err) => {
  console.log("UNCAUGHT EXCEPTION! ðŸ’¥ Shutting down...");
  console.log(err.name, err);
  process.exit(1);
});

//-------------------------------------------------------------------

const app = require("./app");
dotenv.config({ path: "./config/config.env" });


// console.log(
// "\n\ndatabase Uri:" +`${Db_local}`);
mongoose.connect('mongodb://contentp_admin:samcontent1403planet@contentplanet.agency/contentp_main', {
    useNewUrlParser: true,
    useUnifiedTopology: true,
    useFindAndModify:false
  })
  .then(() =>
    console.log("DB connection successfully!...")
  ).catch(err=>{
      console.log(err)
  });
  mongoose.set('debug', true)
const port = process.env.PORT || 3000;



const server = app.listen(port, () => {
  console.log(
    "App running on port:" + `${port} ....`
  );
});

//-------------------------------------------------------------------

process.on("unhandledRejection", (err) => {
  console.log("UNHANDLED REJECTION! ðŸ’¥ Shutting down...");
  console.log(err.name, err);
  server.close(() => {
    process.exit(1);
  });
});

process.on("SIGTERM", () => {
  console.log("ðŸ‘‹ SIGTERM RECEIVED. Shutting down gracefully");
  server.close(() => {
    console.log("ðŸ’¥ Process terminated!");
  });
});
