const express = require("express");
const path = require("path");
const expressLayout = require("express-ejs-layouts");
const morgan = require("morgan");
const helmet = require("helmet");

//---------------------------------------------------------
const globalErrorHandler = require("./Controller/errorController");
const viewRouter = require("./Routers/viewRouter");
const categoryRouter = require("./Routers/categoryRouter");
const AppError = require("./Utils/AppError");
//---------------------------------------------------------

const app = express();
//* static
console.log(path.join(__dirname, "public"));
app.use(express.static(path.join(__dirname, "public")));

// Set security HTTP headers

// app.use(
//     helmet({
//         contentSecurityPolicy: false,
//     })
// );

// Logging

if (process.env.NODE_ENV === "development") {
  app.use(morgan("dev"));
}

//* View Engine
app.use(expressLayout);
app.set("view engine", "ejs");
app.set("views", "Views");
app.set("layout", "./layouts/mainLayout");

//* Routers

app.use("/", viewRouter);
app.use("/blog/category", categoryRouter);
app.use("*", (req, res) => {
   return res.status(404).render("public/errorPage", {
    layout: "./layouts/mainLayoute",
    err: "Not Found",
    path: "/error",
  });
});
app.use(globalErrorHandler);
// safhe ok she

module.exports = app;
