 
  document.getElementById("newsletter-form").addEventListener("submit", async function (e) {
    e.preventDefault();

    const email = document.getElementById("newsletter-email").value.trim();

    if (!email) {
      alert("Please enter your email address.");
      return;
    }

    try {
      const response = await fetch("http://127.0.0.1:5000/api/v1/newslatter", {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
        },
        body: JSON.stringify({ email }),
      });

      if (response.ok) {
        alert("You’ve successfully subscribed!");
        document.getElementById("newsletter-form").reset();
      } else {
        const err = await response.json();
        alert("Error: " + (err.message || "Subscription failed."));
      }
    } catch (err) {
      console.error(err);
      alert("Network error. Please try again.");
    }
  });